/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.handlers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import stormedpanda.simplyjetpacks.handlers.CommonJetpackHandler;
import stormedpanda.simplyjetpacks.item.JetpackItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleCharger;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEHover;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEngine;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleHover;
import stormedpanda.simplyjetpacks.network.packets.PacketUpdateInput;
import stormedpanda.simplyjetpacks.network.packets.PacketUpdateThrottle;
import stormedpanda.simplyjetpacks.screen.JetpackScreen;
import stormedpanda.simplyjetpacks.util.JetpackUtil;

public class KeybindHandler {
    private static boolean lastFlyState = false;
    private static boolean lastDescendState = false;
    private static boolean lastForwardState = false;
    private static boolean lastBackwardState = false;
    private static boolean lastLeftState = false;
    private static boolean lastRightState = false;
    public static KeyBinding JETPACK_GUI_KEY;
    public static KeyBinding JETPACK_ENGINE_KEY;
    public static KeyBinding JETPACK_HOVER_KEY;
    public static KeyBinding JETPACK_EHOVER_KEY;
    public static KeyBinding JETPACK_CHARGER_KEY;
    public static KeyBinding JETPACK_THROTTLE_INCREASE;
    public static KeyBinding JETPACK_THROTTLE_DECREASE;

    public static void setup() {
        JETPACK_GUI_KEY = new KeyBinding("keybind.simplyjetpacks.jetpack_gui", 75, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_GUI_KEY);
        JETPACK_ENGINE_KEY = new KeyBinding("keybind.simplyjetpacks.jetpack_engine", 74, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_ENGINE_KEY);
        JETPACK_HOVER_KEY = new KeyBinding("keybind.simplyjetpacks.jetpack_hover", 72, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_HOVER_KEY);
        JETPACK_EHOVER_KEY = new KeyBinding("keybind.simplyjetpacks.jetpack_ehover", -1, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_EHOVER_KEY);
        JETPACK_CHARGER_KEY = new KeyBinding("keybind.simplyjetpacks.jetpack_charger", -1, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_CHARGER_KEY);
        JETPACK_THROTTLE_INCREASE = new KeyBinding("keybind.simplyjetpacks.jetpack_throttle_increase", 46, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_THROTTLE_INCREASE);
        JETPACK_THROTTLE_DECREASE = new KeyBinding("keybind.simplyjetpacks.jetpack_throttle_decrease", 44, "keybind.simplyjetpacks.category");
        ClientRegistry.registerKeyBinding((KeyBinding)JETPACK_THROTTLE_DECREASE);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack chestStack = JetpackUtil.getFromBothSlots((PlayerEntity)player);
        Item chestItem = null;
        if (!chestStack.func_190926_b()) {
            chestItem = chestStack.func_77973_b();
        }
        if (chestItem instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)chestItem;
            if (JETPACK_GUI_KEY.func_151470_d()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new JetpackScreen());
            }
            if (JETPACK_ENGINE_KEY.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketToggleEngine());
            }
            if (JETPACK_HOVER_KEY.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketToggleHover());
            }
            if (JETPACK_EHOVER_KEY.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketToggleEHover());
            }
            if (JETPACK_CHARGER_KEY.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketToggleCharger());
            }
            if (JETPACK_THROTTLE_INCREASE.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketUpdateThrottle(Math.max(0, Math.min(100, jetpack.getThrottle(chestStack) + 10))));
            }
            if (JETPACK_THROTTLE_DECREASE.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketUpdateThrottle(Math.max(0, Math.min(100, jetpack.getThrottle(chestStack) - 10))));
            }
        }
    }

    private static void tickEnd() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            boolean flyState = mc.field_71439_g.field_71158_b.field_78901_c;
            boolean descendState = mc.field_71439_g.field_71158_b.field_228350_h_;
            boolean forwardState = mc.field_71439_g.field_71158_b.field_187255_c;
            boolean backwardState = mc.field_71439_g.field_71158_b.field_187256_d;
            boolean leftState = mc.field_71439_g.field_71158_b.field_187257_e;
            boolean rightState = mc.field_71439_g.field_71158_b.field_187258_f;
            if (flyState != lastFlyState || descendState != lastDescendState || forwardState != lastForwardState || backwardState != lastBackwardState || leftState != lastLeftState || rightState != lastRightState) {
                lastFlyState = flyState;
                lastDescendState = descendState;
                lastForwardState = forwardState;
                lastBackwardState = backwardState;
                lastLeftState = leftState;
                lastRightState = rightState;
                NetworkHandler.sendToServer(new PacketUpdateInput(flyState, descendState, forwardState, backwardState, leftState, rightState));
                CommonJetpackHandler.update((PlayerEntity)mc.field_71439_g, flyState, descendState, forwardState, backwardState, leftState, rightState);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            KeybindHandler.tickEnd();
        }
    }
}

